/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

public class ExtendedInput
extends qr {
    private kh fontRenderer;
    private int width;
    private int height;
    private static boolean inputHelperIsActive = false;
    private static int inputHelperMode = 0;
    private boolean cursorNeedsReset = false;
    private String strokes = "";
    private static File minecraftDir;
    private static File settingDir;
    private static File settings;
    private static HashMap<String, Integer> RomajiCnvTblMap;
    private static String[] RomajiCnvTblChar;
    private static String[] RomajiCnvTblNext;
    private static HashMap<Integer, String> KanaNormalKeyMap;
    private static HashMap<Integer, String> KanaShiftKeyMap;
    private static int japaneseCharacterType;
    private static boolean TableInitialized;
    private static int InputLanguage;
    private static int ShortCutLanguage;
    private static final String availableSignsInJapanese = " 0123456789!\"#$%&'()=^|@{;:+*}<>?_";

    public ExtendedInput() {
        String[] stringArray;
        Object object;
        BufferedReader bufferedReader;
        minecraftDir = Minecraft.a("minecraft");
        settingDir = new File(minecraftDir, "mods" + File.separator + "zeeksphere");
        settings = new File(settingDir, "MLE_settings.txt");
        if (ShortCutLanguage == 0) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(settings)));
                while ((object = bufferedReader.readLine()) != null) {
                    stringArray = ((String)object).split("=", -1);
                    if (stringArray.length != 2 || !stringArray[0].trim().equals("shortcutlanguage")) continue;
                    ShortCutLanguage = Integer.parseInt(stringArray[1].trim());
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!TableInitialized) {
            try {
                String[] stringArray2;
                String string;
                RomajiCnvTblMap = new HashMap();
                object = new ArrayList();
                stringArray = new ArrayList();
                bufferedReader = new BufferedReader(new InputStreamReader(ExtendedInput.class.getResourceAsStream("/romaji_table.txt"), "UTF-8"));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("#") || string.startsWith(" ") || string.length() == 0 || RomajiCnvTblMap.containsKey((stringArray2 = string.split(" ", -1))[0])) continue;
                    if (stringArray2[0].indexOf("_") >= 0) {
                        for (int i2 = 0; i2 < availableSignsInJapanese.length(); ++i2) {
                            RomajiCnvTblMap.put(stringArray2[0].replace('_', availableSignsInJapanese.charAt(i2)), RomajiCnvTblMap.size());
                            ((ArrayList)object).add(stringArray2[1].replace('_', availableSignsInJapanese.charAt(i2)));
                            stringArray.add(stringArray2.length >= 3 ? stringArray2[2].replace('_', availableSignsInJapanese.charAt(i2)) : "");
                        }
                        continue;
                    }
                    RomajiCnvTblMap.put(stringArray2[0], RomajiCnvTblMap.size());
                    ((ArrayList)object).add(stringArray2[1]);
                    stringArray.add(stringArray2.length >= 3 ? stringArray2[2] : "");
                }
                bufferedReader.close();
                RomajiCnvTblChar = ((ArrayList)object).toArray(new String[0]);
                RomajiCnvTblNext = stringArray.toArray(new String[0]);
                KanaNormalKeyMap = new HashMap();
                KanaShiftKeyMap = new HashMap();
                bufferedReader = new BufferedReader(new InputStreamReader(ExtendedInput.class.getResourceAsStream("/kana_table.txt"), "UTF-8"));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("#") || string.startsWith(" ") || string.length() == 0 || KanaNormalKeyMap.containsKey((stringArray2 = string.split(" ", -1))[0])) continue;
                    KanaNormalKeyMap.put(Integer.parseInt(stringArray2[0]), stringArray2[1]);
                    KanaShiftKeyMap.put(Integer.parseInt(stringArray2[0]), stringArray2.length >= 3 ? stringArray2[2] : stringArray2[1]);
                }
                bufferedReader.close();
                TableInitialized = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private HashMap<Integer, String> makeCharCodeMap(String string) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ExtendedInput.class.getResourceAsStream(string), "UTF-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string2.startsWith("#") || string2.startsWith(" ") || string2.length() == 0 || hashMap.containsKey((stringArray = string2.split(" ", -1))[0])) continue;
                hashMap.put(Integer.parseInt(stringArray[0]), stringArray[1]);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    private ArrayList<HashMap<Integer, String>> makeKeyCodeMap(String string) {
        Object object;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap3 = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap4 = new HashMap<Integer, String>();
        try {
            String string2;
            object = new BufferedReader(new InputStreamReader(ExtendedInput.class.getResourceAsStream(string), "UTF-8"));
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                String[] stringArray;
                if (string2.startsWith("#") || string2.startsWith(" ") || string2.length() == 0 || hashMap.containsKey((stringArray = string2.split(" ", -1))[0])) continue;
                hashMap.put(Integer.parseInt(stringArray[0]), stringArray[1]);
                hashMap2.put(Integer.parseInt(stringArray[0]), stringArray.length >= 3 ? stringArray[2] : stringArray[1]);
                hashMap3.put(Integer.parseInt(stringArray[0]), stringArray.length >= 4 ? stringArray[3] : stringArray[1]);
                hashMap4.put(Integer.parseInt(stringArray[0]), stringArray.length >= 5 ? stringArray[4] : (String)hashMap2.get(Integer.parseInt(stringArray[0])));
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new ArrayList<HashMap<Integer, String>>();
        ((ArrayList)object).add(hashMap);
        ((ArrayList)object).add(hashMap2);
        ((ArrayList)object).add(hashMap3);
        ((ArrayList)object).add(hashMap4);
        return object;
    }

    public void setRendererAndResolution(kh kh2, int n2, int n3) {
        this.fontRenderer = kh2;
        this.width = n2;
        this.height = n3;
    }

    private void startInputHelper(int n2) {
        inputHelperMode = n2;
        inputHelperIsActive = true;
        this.renderInputHelper();
    }

    private void endInputHelper() {
        inputHelperIsActive = false;
    }

    public void toggleInputMode() {
        if (ShortCutLanguage == 0) {
            this.startInputHelper(0);
        } else {
            InputLanguage = InputLanguage == 0 ? ShortCutLanguage : 0;
            this.cursorNeedsReset = true;
        }
    }

    public void selectInputMode() {
        this.startInputHelper(1);
    }

    public void toggleJapaneseInputMode() {
        if (InputLanguage == 1 || InputLanguage == 2) {
            japaneseCharacterType = japaneseCharacterType == 0 ? 1 : 0;
            this.cursorNeedsReset = true;
        }
    }

    public void setEnglishMode() {
        InputLanguage = 0;
        this.strokes = "";
    }

    public void setJapaneseMode() {
        InputLanguage = 1;
        this.strokes = "";
    }

    public void setJapaneseHiragana() {
        japaneseCharacterType = 0;
        this.strokes = "";
        this.cursorNeedsReset = true;
    }

    public void setJapaneseKatakana() {
        japaneseCharacterType = 1;
        this.strokes = "";
        this.cursorNeedsReset = true;
    }

    public void renderIndicator() {
        if (InputLanguage != 0) {
            this.renderInputModeIndicator();
        }
        if (inputHelperIsActive) {
            this.renderInputHelper();
        }
    }

    public void renderTest() {
        this.a(32, 2, 326, 14, Integer.MIN_VALUE);
        this.b(this.fontRenderer, "\u3073\u3087\u3046\u304c\u30c6\u30b9\u30c8", 34, 4, 0xFFFFFF);
    }

    private void renderInputModeIndicator() {
        if (InputLanguage < 0) {
            this.a(2, 2, 2 + this.fontRenderer.a("[Debug]") + 4, 14, Integer.MIN_VALUE);
            this.b(this.fontRenderer, "[Debug]", 4, 4, 0xFFFFFF);
        } else if (InputLanguage == 1) {
            this.a(2, 2, 2 + this.fontRenderer.a("[R" + (this.getCursor() == "\ue000" ? "\u3042" : "\u30a2") + "]") + 4, 14, Integer.MIN_VALUE);
            this.b(this.fontRenderer, "[R" + (this.getCursor() == "\ue000" ? "\u3042" : "\u30a2") + "]", 4, 4, 0xFFFFFF);
        } else if (InputLanguage == 2) {
            this.a(2, 2, 2 + this.fontRenderer.a("[" + (this.getCursor() == "\ue000" ? "\u3042" : "\u30a2") + "]") + 4, 14, Integer.MIN_VALUE);
            this.b(this.fontRenderer, "[" + (this.getCursor() == "\ue000" ? "\u3042" : "\u30a2") + "]", 4, 4, 0xFFFFFF);
        }
    }

    public boolean InputHelperIsActive() {
        return inputHelperIsActive;
    }

    private void renderInputHelper() {
        if (inputHelperMode == 0) {
            this.renderInputHelperLangSelector();
        } else if (inputHelperMode == 1) {
            this.renderInputHelperLangSelector();
        }
    }

    private void renderInputHelperLangSelector() {
        int n2;
        String[] stringArray = new String[]{"\u306b\u307b\u3093\u3054-\u30ed\u30fc\u30de\u3058", "\u306b\u307b\u3093\u3054-\u304b\u306a"};
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (arrayList.size() == n3) {
                arrayList.add(String.valueOf(n2 + 1) + ":" + stringArray[n2]);
                continue;
            }
            if (this.fontRenderer.a((String)arrayList.get(n3) + " " + String.valueOf(n2 + 1) + ":" + stringArray[n2]) > this.width - 4) {
                ++n3;
                --n2;
                continue;
            }
            arrayList.set(n3, (String)arrayList.get(n3) + " " + String.valueOf(n2 + 1) + ":" + stringArray[n2]);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            this.a(0, n2 * 10, this.width, 2 + (n2 + 1) * 10, Integer.MIN_VALUE);
            this.b(this.fontRenderer, (String)arrayList.get(n2), 2, 2 + 10 * n2, 0xFFFFFF);
        }
    }

    public String handleInput(char c2, int n2, String string) {
        if (inputHelperIsActive) {
            return this.handleInputHelper(c2, n2, string);
        }
        if (n2 == 14) {
            return this.handleStroke(c2, n2, string);
        }
        if (n2 == 57 && (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42))) {
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                this.selectInputMode();
            } else {
                this.toggleInputMode();
            }
            return string;
        }
        if (n2 == 123 || n2 == 37 && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157))) {
            this.toggleJapaneseInputMode();
            n2 = 0;
            return string;
        }
        return this.handleStroke(c2, n2, string);
    }

    public String handleInputHelper(char c2, int n2, String string) {
        if (!(inputHelperMode != 0 && inputHelperMode != 1 || c2 != '1' && c2 != '2')) {
            if (!settingDir.exists()) {
                settingDir.mkdirs();
            }
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(settings)));
                printWriter.println("shortcutlanguage = " + c2);
                printWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.endInputHelper();
            ShortCutLanguage = InputLanguage = c2 - 48;
            this.cursorNeedsReset = true;
        }
        if (c2 == '?') {
            this.endInputHelper();
            InputLanguage = -1;
            this.cursorNeedsReset = true;
        }
        return string;
    }

    public String handleStroke(char c2, int n2, String string) {
        if (InputLanguage < 0) {
            return "c: " + String.valueOf(c2) + "(" + String.valueOf((int)c2) + "), " + "i: " + String.valueOf(n2);
        }
        if (InputLanguage == 1) {
            return this.handleStrokeRomaji(c2, n2, string);
        }
        if (InputLanguage == 2) {
            return this.handleStrokeKana(c2, n2, string);
        }
        if (c2 == '\b') {
            return string.length() > 0 ? string.substring(0, string.length() - 1) : string;
        }
        if ('\u0000' <= c2 && c2 < ' ' || c2 == '\u007f') {
            return string;
        }
        return string + c2;
    }

    private String handleStrokeRomaji(char c2, int n2, String string) {
        String string2 = "";
        if (n2 == 14) {
            if (this.strokes.length() > 0) {
                this.strokes = "";
                return string;
            }
            return string.length() > 0 ? string.substring(0, string.length() - 1) : string;
        }
        if (('\u0000' > c2 || c2 >= ' ') && c2 != '\u007f') {
            this.strokes = this.strokes + String.valueOf(c2);
        }
        if (this.strokes.length() == 1 && this.strokes != this.strokes.toLowerCase()) {
            japaneseCharacterType = japaneseCharacterType == 0 ? 1 : 0;
        }
        for (int i2 = 0; i2 < this.strokes.length(); ++i2) {
            if (!RomajiCnvTblMap.containsKey(this.strokes.substring(i2).toLowerCase())) continue;
            this.strokes = this.strokes.substring(i2);
            break;
        }
        if (RomajiCnvTblMap.containsKey(this.strokes.toLowerCase())) {
            string2 = RomajiCnvTblChar[RomajiCnvTblMap.get(this.strokes.toLowerCase())];
            if (japaneseCharacterType == 1) {
                string2 = this.hiraganaToKatakana(string2);
            }
            this.strokes = RomajiCnvTblNext[RomajiCnvTblMap.get(this.strokes.toLowerCase())];
            if (n2 == 83 || n2 == 78 || n2 == 74 || n2 == 55 || n2 == 181) {
                string2 = string2.substring(0, string2.length() - 1) + String.valueOf(c2);
            }
            return string + string2;
        }
        if (availableSignsInJapanese.indexOf(c2) >= 0) {
            string2 = String.valueOf(c2);
            this.strokes = "";
            return string + string2;
        }
        return string;
    }

    private String handleStrokeKana(char c2, int n2, String string) {
        if (n2 == 14) {
            return string.length() > 0 ? string.substring(0, string.length() - 1) : string;
        }
        String string2 = "";
        if (c2 == ' ') {
            string2 = " ";
        }
        if (KanaNormalKeyMap.containsKey(n2)) {
            String string3 = string2 = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42) ? KanaShiftKeyMap.get(n2) : KanaNormalKeyMap.get(n2);
            if (japaneseCharacterType == 1) {
                string2 = this.hiraganaToKatakana(string2);
            }
            if (string2.equals("\u309b") && string.length() > 0) {
                if (string.charAt(string.length() - 1) == '\u3046' || string.charAt(string.length() - 1) == '\u30a6') {
                    string2 = String.valueOf((char)(string.charAt(string.length() - 1) + 78));
                    string = string.substring(0, string.length() - 1);
                } else if ("\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306f\u3072\u3075\u3078\u307b\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30cf\u30d2\u30d5\u30d8\u30db".indexOf(string.charAt(string.length() - 1)) >= 0) {
                    string2 = String.valueOf((char)(string.charAt(string.length() - 1) + '\u0001'));
                    string = string.substring(0, string.length() - 1);
                } else {
                    string2 = "";
                }
            }
            if (string2.equals("\u309c") && string.length() > 0) {
                if ("\u306f\u3072\u3075\u3078\u307b\u30cf\u30d2\u30d5\u30d8\u30db".indexOf(string.charAt(string.length() - 1)) >= 0) {
                    string2 = String.valueOf((char)(string.charAt(string.length() - 1) + 2));
                    string = string.substring(0, string.length() - 1);
                } else {
                    string2 = "";
                }
            }
        }
        return string + string2;
    }

    private String handleStrokeByKeyCode(ArrayList<HashMap<Integer, String>> arrayList, char c2, int n2, String string) {
        if (n2 == 14) {
            return string.length() > 0 ? string.substring(0, string.length() - 1) : string;
        }
        if ('\u0000' <= c2 && c2 < ' ' || c2 == '\u007f') {
            return string;
        }
        String string2 = "";
        if (c2 == ' ') {
            string2 = " ";
        }
        if (arrayList.get(0).containsKey(n2)) {
            string2 = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42) ? arrayList.get(1).get(n2) : arrayList.get(0).get(n2);
        }
        return string + string2;
    }

    private String handleStrokeByCharMap(HashMap<Integer, String> hashMap, char c2, int n2, String string) {
        String string2;
        if (n2 == 14) {
            return string.length() > 0 ? string.substring(0, string.length() - 1) : string;
        }
        String string3 = string2 = hashMap.containsKey(c2) ? hashMap.get(c2) : String.valueOf(c2);
        if (sb.a.indexOf(string2) < 0) {
            string2 = "";
        }
        return string + string2;
    }

    private String hiraganaToKatakana(String string) {
        String string2 = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            string2 = '\u3041' <= string.charAt(i2) && string.charAt(i2) <= '\u3094' ? string2 + String.valueOf((char)(string.charAt(i2) - 12353 + 12449)) : string2 + String.valueOf(string.charAt(i2));
        }
        return string2;
    }

    private String katakanaToHiragna(String string) {
        String string2 = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            string2 = '\u30a1' <= string.charAt(i2) && string.charAt(i2) <= '\u30f4' ? string2 + "" + (char)(string.charAt(i2) - 12449 + 12353) : string2 + string;
        }
        return string2;
    }

    private String addGreekAcute(String string) {
        if (string.equals("\u0391")) {
            return "\u0386";
        }
        if (string.equals("\u0395")) {
            return "\u0388";
        }
        if (string.equals("\u0397")) {
            return "\u0389";
        }
        if (string.equals("\u0399")) {
            return "\u038a";
        }
        if (string.equals("\u039f")) {
            return "\u038c";
        }
        if (string.equals("\u03a5")) {
            return "\u038e";
        }
        if (string.equals("\u03a9")) {
            return "\u038f";
        }
        if (string.equals("\u03b1")) {
            return "\u03ac";
        }
        if (string.equals("\u03b5")) {
            return "\u03ad";
        }
        if (string.equals("\u03b7")) {
            return "\u03ae";
        }
        if (string.equals("\u03b9")) {
            return "\u03af";
        }
        if (string.equals("\u03bf")) {
            return "\u03cc";
        }
        if (string.equals("\u03c5")) {
            return "\u03cd";
        }
        if (string.equals("\u03c9")) {
            return "\u03ce";
        }
        return string;
    }

    private String addGreekDiaeresis(String string) {
        if (string.equals("\u0399")) {
            return "\u03aa";
        }
        if (string.equals("\u03a5")) {
            return "\u03ab";
        }
        if (string.equals("\u03b9")) {
            return "\u03ca";
        }
        if (string.equals("\u03c5")) {
            return "\u03cb";
        }
        return string;
    }

    private String addGreekAcuteDiaeresis(String string) {
        if (string.equals("\u03b9")) {
            return "\u0390";
        }
        if (string.equals("\u03c5")) {
            return "\u03b0";
        }
        return string;
    }

    public boolean CursorNeedsReset() {
        boolean bl2 = this.cursorNeedsReset;
        this.cursorNeedsReset = false;
        return bl2;
    }

    public String getCursor() {
        if (InputLanguage == 1 || InputLanguage == 2) {
            if (japaneseCharacterType == 0) {
                return "\ue000";
            }
            return "\ue001";
        }
        return "_";
    }

    static {
        japaneseCharacterType = 0;
        TableInitialized = false;
        InputLanguage = 0;
        ShortCutLanguage = 0;
    }
}

